DROP TABLE IF EXISTS `admin_access_group_items`;
CREATE TABLE `admin_access_group_items`
(
    `admin_access_group_id` INT(11) UNSIGNED NOT NULL DEFAULT '0',
    `identifier`            varchar(255) NOT NULL DEFAULT '',
    `type`                  ENUM('CONTROLLER', 'PAGE', 'AJAX_HANDLER', 'ROUTE') NOT NULL DEFAULT 'CONTROLLER',
    PRIMARY KEY (`identifier`, `type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO admin_access_group_items (admin_access_group_id, identifier, type)
VALUES (1, 'DefaultApiV2', 'CONTROLLER'),
       (1, 'HttpApiV2', 'CONTROLLER'),
       (1, '/api.php/v3', 'ROUTE'),
       (2, '/admin', 'ROUTE'),
       (2, '/admin/api/user-configuration', 'ROUTE'),
       (2, '/admin/dashboard', 'ROUTE'),
       (2, '/admin/session/keep-alive', 'ROUTE'),
       (2, 'admin.php', 'PAGE'),
       (2, 'AdminInfobox', 'AJAX_HANDLER'),
       (2, 'Dashboard', 'CONTROLLER'),
       (2, 'GambioUpdate', 'AJAX_HANDLER'),
       (2, 'LoadAdminInfoBoxes', 'AJAX_HANDLER'),
       (2, 'LoadNews', 'AJAX_HANDLER'),
       (2, 'request_port.php', 'PAGE'),
       (2, 'start.php', 'PAGE'),
       (2, 'UserConfiguration', 'CONTROLLER'),
       (3, '/admin/dhlreturns', 'ROUTE'),
       (3, 'Dashboard/getLatestOrders', 'CONTROLLER'),
       (3, 'gm_order_menu.php', 'PAGE'),
       (3, 'gm_send_order.php', 'PAGE'),
       (3, 'mobile.php', 'PAGE'),
       (3, 'orders.php', 'PAGE'),
       (3, 'orders_actions.php', 'PAGE'),
       (3, 'orders_edit.php', 'PAGE'),
       (3, 'orders_edit_options.php', 'PAGE'),
       (3, 'orders_edit_other.php', 'PAGE'),
       (3, 'orders_edit_products.php', 'PAGE'),
       (3, 'orders_status.php', 'PAGE'),
       (3, 'OrdersApiV2', 'CONTROLLER'),
       (3, 'OrdersHistoryApiV2', 'CONTROLLER'),
       (3, 'OrdersItemsApiV2', 'CONTROLLER'),
       (3, 'OrdersItemsAttributesApiV2', 'CONTROLLER'),
       (3, 'OrdersModalsAjax', 'CONTROLLER'),
       (3, 'OrdersOverview', 'CONTROLLER'),
       (3, 'OrdersOverviewAjax', 'CONTROLLER'),
       (3, 'OrderStatusesApiV2', 'CONTROLLER'),
       (3, 'OrdersTotalsApiV2', 'CONTROLLER'),
       (3, 'OrderTooltip', 'CONTROLLER'),
       (3, 'popup_memo.php', 'PAGE'),
       (4, 'withdrawals.php', 'PAGE'),
       (4, 'Withdrawals', 'CONTROLLER'),
       (4, '/api.php/v3/withdrawals', 'ROUTE'),
       (5, 'InvoicesModalsAjax', 'CONTROLLER'),
       (5, 'InvoicesOverview', 'CONTROLLER'),
       (5, 'InvoicesOverviewAjax', 'CONTROLLER'),
       (5, 'gm_pdf_order.php', 'PAGE'),
       (5, 'OrderAdmin', 'AJAX_HANDLER'),
       (6, 'AddressesApiV2', 'CONTROLLER'),
       (6, 'AddressFormatsApiV2', 'CONTROLLER'),
       (6, 'AttachmentsApiV2', 'CONTROLLER'),
       (6, 'CustomersApiV2', 'CONTROLLER'),
       (6, 'CustomerLogin', 'CONTROLLER'),
       (6, 'create_account.php', 'PAGE'),
       (6, '/admin/customers', 'PAGE'),
       (6, 'gm_emails.php', 'PAGE'),
       (6, 'gm_emails_preview.php', 'PAGE'),
       (7, 'customers_status.php', 'PAGE'),
       (7, 'CustomerGroup', 'CONTROLLER'),
       (8, 'Emails', 'CONTROLLER'),
       (8, 'EmailsApiV2', 'CONTROLLER'),
       (8, 'mail.php', 'PAGE'),
       (9, 'AdminAccess', 'CONTROLLER'),
       (10, 'GoogleOAuth', 'CONTROLLER'),
       (11, '/admin/api/image-lists', 'ROUTE'),
       (11, '/admin/api/options', 'ROUTE'),
       (11, '/admin/api/products', 'ROUTE'),
       (6, '/admin/api/customers/search', 'ROUTE'),
       (6, '/admin/api/customer-configurations', 'ROUTE'),
       (6, '/admin/api/customer-products', 'ROUTE'),
       (6, '/admin/api/customers-overview', 'ROUTE'),
       (6, '/admin/api/customer-profile', 'ROUTE'),
       (6, '/admin/api/create-customer', 'ROUTE'),
       (6, '/admin/api/delete-customer', 'ROUTE'),
       (6, '/admin/api/delete-guests', 'ROUTE'),
       (6, '/admin/api/update-customer', 'ROUTE'),
       (6, '/admin/api/customer', 'ROUTE'),
       (6, '/admin/api/change-customer-password', 'ROUTE'),
       (6, '/admin/api/change-customer-disallowed-payment-and-shipping-modules', 'ROUTE'),
       (6, '/admin/api/change-customers-group', 'ROUTE'),
       (6, '/admin/api/validate-email', 'ROUTE'),
       (6, '/admin/api/customer-register', 'ROUTE'),
       (6, '/admin/api/customer-user-configuration', 'ROUTE'),
       (6, '/admin/api/log-admin-activities', 'ROUTE'),
       (11, '/admin/api/vpe', 'ROUTE'),
       (11, '/admin/options', 'ROUTE'),
       (11, '/admin/products', 'ROUTE'),
       (11, '/api.php/v3/image-lists', 'ROUTE'),
       (11, '/api.php/v3/options', 'ROUTE'),
       (11, '/api.php/v3/products', 'ROUTE'),
       (11, '/api.php/v3/customers', 'ROUTE'),
       (11, 'categories.php', 'PAGE'),
       (11, 'CategoriesApiV2', 'CONTROLLER'),
       (11, 'CategoryIconsApiV2', 'CONTROLLER'),
       (11, 'CategoryImagesApiV2', 'CONTROLLER'),
       (11, 'FeatureSetAdmin', 'AJAX_HANDLER'),
       (11, 'gm_feature_control.php', 'PAGE'),
       (11, 'new_attributes.php', 'PAGE'),
       (11, 'NewAttributes', 'CONTROLLER'),
       (11, 'ProductImagesApiV2', 'CONTROLLER'),
       (11, 'ProductPricesApiV2', 'CONTROLLER'),
       (11, 'products_attributes.php', 'PAGE'),
       (11, 'ProductsApiV2', 'CONTROLLER'),
       (11, 'ProductsLinksApiV2', 'CONTROLLER'),
       (11, 'properties_combis.php', 'PAGE'),
       (11, 'SpecialOffersApiV2', 'CONTROLLER'),
       (11, 'specials.php', 'PAGE'),
       (12, 'QuickEditOverview', 'CONTROLLER'),
       (12, 'QuickEditOverviewAjax', 'CONTROLLER'),
       (12, 'QuickEditProductPropertiesAjax', 'CONTROLLER'),
       (12, 'QuickEditSpecialPricesAjax', 'CONTROLLER'),
       (13, 'Manufacturer', 'CONTROLLER'),
       (13, 'ManufacturerAjax', 'CONTROLLER'),
       (14, 'VPE', 'CONTROLLER'),
       (14, 'VPEAjax', 'CONTROLLER'),
       (15, 'QuantityUnit', 'CONTROLLER'),
       (15, 'QuantityUnitAjax', 'CONTROLLER'),
       (16, 'gm_gprint.php', 'PAGE'),
       (17, 'cross_sell_groups.php', 'PAGE'),
       (18, 'reviews.php', 'PAGE'),
       (20, 'TemplateConfiguration', 'CONTROLLER'),
       (21, 'gm_logo.php', 'PAGE'),
       (22, 'SlidersDetails', 'CONTROLLER'),
       (22, 'SlidersDetailsAjax', 'CONTROLLER'),
       (22, 'SlidersOverview', 'CONTROLLER'),
       (22, 'SlidersOverviewAjax', 'CONTROLLER'),
       (23, 'ContentManagerAjax', 'CONTROLLER'),
       (23, 'ContentManagerElements', 'CONTROLLER'),
       (23, 'ContentManagerPages', 'CONTROLLER'),
       (23, 'ContentManagerProductContents', 'CONTROLLER'),
       (23, 'content_preview.php', 'PAGE'),
       (24, 'gm_offline.php', 'PAGE'),
       (24, 'JobManager', 'AJAX_HANDLER'),
       (25, 'banner_manager.php', 'PAGE'),
       (25, 'banner_statistics.php', 'PAGE'),
       (26, 'ImageProcessing', 'CONTROLLER'),
       (28, 'clear_cache.php', 'PAGE'),
       (28, '/admin/clear-cache', 'ROUTE'),
       (28, 'AdminCacheAjax', 'CONTROLLER'),
       (28, 'AdminCacheAjax/default', 'CONTROLLER'),
       (28, 'AdminCacheAjax/page', 'CONTROLLER'),
       (28, 'AdminCacheAjax/module', 'CONTROLLER'),
       (28, 'AdminCacheAjax/category', 'CONTROLLER'),
       (28, 'AdminCacheAjax/filter', 'CONTROLLER'),
       (28, 'AdminCacheAjax/text', 'CONTROLLER'),
       (28, 'AdminCacheAjax/email', 'CONTROLLER'),
       (29, 'timer.php', 'PAGE'),
       (31, 'gm_lang_edit.php', 'PAGE'),
       (32, 'module_newsletter.php', 'PAGE'),
       (33, 'backup.php', 'PAGE'),
       (34, 'gm_backup_files_zip.php', 'PAGE'),
       (35, 'show_logs.php', 'PAGE'),
       (35, 'Logging', 'CONTROLLER'),
       (36, 'server_info.php', 'PAGE'),
       (37, 'EmbeddedModule/minisql', 'CONTROLLER'),
       (37, 'phpminiadmin.php', 'PAGE'),
       (38, 'ResponsiveFileManager', 'CONTROLLER'),
       (39, 'AfterbuyAjax', 'CONTROLLER'),
       (39, 'Geschaeftskundenversand', 'CONTROLLER'),
       (39, 'PackedDownload', 'CONTROLLER'),
       (39, 'SharedShoppingCartConfiguration', 'CONTROLLER'),
       (39, 'Shipcloud', 'CONTROLLER'),
       (39, 'amazonadvpay.php', 'PAGE'),
       (39, 'brickfox.php', 'PAGE'),
       (39, 'ekomi.php', 'PAGE'),
       (39, 'findologic_config.php', 'PAGE'),
       (39, 'gm_janolaw.php', 'PAGE'),
       (39, 'gm_trusted_shop_id.php', 'PAGE'),
       (39, 'hermes_collection.php', 'PAGE'),
       (39, 'hermes_config.php', 'PAGE'),
       (39, 'hermes_info.php', 'PAGE'),
       (39, 'hermes_list.php', 'PAGE'),
       (39, 'hermes_order.php', 'PAGE'),
       (39, 'interkurierConnect.php', 'PAGE'),
       (39, 'klarna_config.php', 'PAGE'),
       (39, 'lettr_de.php', 'PAGE'),
       (39, 'magnalister.php', 'PAGE'),
       (39, 'mailbeez.php', 'PAGE'),
       (39, 'mediafinanz.php', 'PAGE'),
       (39, 'orders_iloxx.php', 'PAGE'),
       (39, 'paypal.php', 'PAGE'),
       (39, 'shopgate.php', 'PAGE'),
       (39, 'yatego.php', 'PAGE'),
       (40, 'AfterbuyModuleCenterModule', 'CONTROLLER'),
       (40, 'AmazonAdvPaymentsModuleCenterModule', 'CONTROLLER'),
       (40, 'BrickfoxModuleCenterModule', 'CONTROLLER'),
       (40, 'EkomiModuleCenterModule', 'CONTROLLER'),
       (40, 'FindologicModuleCenterModule', 'CONTROLLER'),
       (40, 'GeschaeftskundenversandModuleCenterModule', 'CONTROLLER'),
       (40, 'GoogleAdwordConversionModuleCenterModule', 'CONTROLLER'),
       (40, 'HermesModuleCenterModule', 'CONTROLLER'),
       (40, 'IloxxModuleCenterModule', 'CONTROLLER'),
       (40, 'ItRechtModuleCenterModule', 'CONTROLLER'),
       (40, 'JanolawModuleCenterModule', 'CONTROLLER'),
       (40, 'KlarnaModuleCenterModule', 'CONTROLLER'),
       (40, 'LettrModuleCenterModule', 'CONTROLLER'),
       (40, 'MagnalisterModuleCenterModule', 'CONTROLLER'),
       (40, 'MailbeezModuleCenterModule', 'CONTROLLER'),
       (40, 'MediafinanzModuleCenterModule', 'CONTROLLER'),
       (40, 'ModuleCenter', 'CONTROLLER'),
       (40, 'NewsletterLinkModuleCenterModule', 'CONTROLLER'),
       (40, 'ParcelshopfinderModuleCenterModule', 'CONTROLLER'),
       (40, 'PaypalNGModuleCenterModule', 'CONTROLLER'),
       (40, 'PostfinderModuleCenterModule', 'CONTROLLER'),
       (40, 'ProductAttributesModuleCenterModule', 'CONTROLLER'),
       (40, 'ProtectedShopsModuleCenterModule', 'CONTROLLER'),
       (40, 'SharedShoppingCartModuleCenterModule', 'CONTROLLER'),
       (40, 'ShipcloudModuleCenterModule', 'CONTROLLER'),
       (40, 'TrustedShopsModuleCenterModule', 'CONTROLLER'),
       (40, 'YategoModuleCenterModule', 'CONTROLLER'),
       (41, 'modules.php', 'PAGE'),
       (42, '/admin/api/statistics/overview', 'ROUTE'),
       (42, '/admin/dashboard/statistics', 'ROUTE'),
       (42, '/admin/statistics/overview', 'ROUTE'),
       (42, 'Dashboard/getStatisticBoxes', 'CONTROLLER'),
       (42, 'gm_counter.php', 'PAGE'),
       (42, 'gm_counter_action.php', 'PAGE'),
       (42, 'stats_campaigns.php', 'PAGE'),
       (42, 'stats_customers.php', 'PAGE'),
       (42, 'stats_products_purchased.php', 'PAGE'),
       (42, 'stats_products_viewed.php', 'PAGE'),
       (42, 'stats_sales_report.php', 'PAGE'),
       (42, 'stats_stock_warning.php', 'PAGE'),
       (42, 'whos_online.php', 'PAGE'),
       (43, 'csv.php', 'PAGE'),
       (46, 'coupon_admin.php', 'PAGE'),
       (46, 'gv_mail.php', 'PAGE'),
       (46, 'gv_queue.php', 'PAGE'),
       (46, 'gv_sent.php', 'PAGE'),
       (46, 'listcategories.php', 'PAGE'),
       (46, 'listproducts.php', 'PAGE'),
       (46, 'validcategories.php', 'PAGE'),
       (46, 'validproducts.php', 'PAGE'),
       (46, 'GiftSystemModuleCenterModule', 'CONTROLLER'),
       (47, '/admin/configurations', 'ROUTE'),
       (47, '/admin/api/configurations', 'ROUTE'),
       (47, 'ShopInformationApiV2', 'CONTROLLER'),
       (47, 'ShopKey', 'CONTROLLER'),
       (47, 'VersionInfo', 'CONTROLLER'),
       (47, 'campaigns.php', 'PAGE'),
       (47, 'configuration.php', 'PAGE'),
       (47, 'gm_miscellaneous.php', 'PAGE'),
       (47, 'gm_pdf.php', 'PAGE'),
       (47, 'gm_pdf_action.php', 'PAGE'),
       (47, '/admin/configuration/save', 'ROUTE'),
       (47, 'Laws', 'CONTROLLER'),
       (47, 'gm_laws.php', 'PAGE'),
       (50, 'shipping_status.php', 'PAGE'),
       (51, 'parcel_services.php', 'PAGE'),
       (51, 'ParcelServicesApiV2', 'CONTROLLER'),
       (51, 'TrackingCodeApiV2', 'CONTROLLER'),
       (51, '/api.php/v3/parcel-services', 'ROUTE'),
       (51, '/api.php/v3/tracking-codes', 'ROUTE'),
       (51, '/admin/parcel-services', 'ROUTE'),
       (51, '/admin/api/parcel-services', 'ROUTE'),
       (52, 'gm_id_starts.php', 'PAGE'),
       (53, 'StaticSeoUrl', 'CONTROLLER'),
       (53, 'StaticSeoUrlAjax', 'CONTROLLER'),
       (53, 'gm_analytics.php', 'PAGE'),
       (53, 'gm_meta.php', 'PAGE'),
       (53, 'gm_meta_action.php', 'PAGE'),
       (53, 'gm_seo_boost.php', 'PAGE'),
       (53, 'gm_sitemap.php', 'PAGE'),
       (53, 'gm_sitemap_creator.php', 'PAGE'),
       (53, 'robots_download.php', 'PAGE'),
       (54, 'CountriesApiV2', 'CONTROLLER'),
       (54, 'TaxClassesApiV2', 'CONTROLLER'),
       (54, 'TaxRatesApiV2', 'CONTROLLER'),
       (54, 'TaxZonesApiV2', 'CONTROLLER'),
       (54, 'ZonesApiV2', 'CONTROLLER'),
       (54, 'countries.php', 'PAGE'),
       (54, 'currencies.php', 'PAGE'),
       (54, 'geo_zones.php', 'PAGE'),
       (54, 'languages.php', 'PAGE'),
       (54, 'tax_classes.php', 'PAGE'),
       (54, 'tax_rates.php', 'PAGE'),
       (54, 'zones.php', 'PAGE'),
       (56, 'HubConfiguration', 'CONTROLLER'),
       (56, 'HubConfigurationAjax', 'CONTROLLER'),
       (56, 'GambioHub', 'CONTROLLER'),
       (56, 'KlarnaHub', 'CONTROLLER'),
       (56, 'PaymentMatchingHub', 'CONTROLLER'),
       (56, 'KlarnaHubSettlements', 'CONTROLLER'),
       (56, 'KlarnaHubBoost', 'CONTROLLER'),
       (57, 'AutoUpdaterAjax', 'CONTROLLER'),
       (57, 'AutoUpdater', 'CONTROLLER'),
       (57, 'AutoUpdaterShopExcludedAjax', 'CONTROLLER'),
       (57, 'GambioStore', 'CONTROLLER'),
       (57, 'GambioStoreAjax', 'CONTROLLER'),
       (58, 'GoogleShopping', 'CONTROLLER'),
       (58, 'GoogleShoppingAjax', 'CONTROLLER'),
       (59, 'GoogleAdWords', 'CONTROLLER'),
       (59, 'AdWordsCampaignsOverviewAjax', 'CONTROLLER'),
       (60, 'GoogleAnalyticsAdmin', 'CONTROLLER'),
       (62, 'StyleEditProductSearch', 'CONTROLLER'),
       (62, 'StyleEditCategorySearch', 'CONTROLLER'),
       (62, 'StyleEdit4Authentication', 'CONTROLLER'),
       (62, 'StyleEdit3Authentication', 'CONTROLLER'),
       (63, 'CronjobsOverview', 'CONTROLLER'),
       (64, 'AdminErrorPage', 'CONTROLLER'),
       (65, 'unknown-admin-access-item', 'CONTROLLER'),
       (65, 'unknown-admin-access-item', 'PAGE'),
       (65, 'unknown-admin-access-item', 'ROUTE'),
       (65, 'unknown-admin-access-item', 'AJAX_HANDLER'),
       (66, '/admin/redirect-rules', 'ROUTE');
